/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.Animations;
import com.tacz.guns.api.client.animation.ObjectAnimation;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.tacz.guns.client.resource.pojo.display.gun.DefaultAnimation;
import com.tacz.guns.client.resource.pojo.display.gun.GunAmmo;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunLod;
import com.tacz.guns.client.resource.pojo.display.gun.GunTransform;
import com.tacz.guns.client.resource.pojo.display.gun.LayerGunShow;
import com.tacz.guns.client.resource.pojo.display.gun.MuzzleFlash;
import com.tacz.guns.client.resource.pojo.display.gun.ShellEjection;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.resource.CommonAssetManager;
import com.tacz.guns.resource.pojo.GunIndexPOJO;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.ColorHex;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_2223;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientGunIndex {
    private String name;
    private String thirdPersonAnimation = "empty";
    private BedrockGunModel gunModel;
    @Nullable
    private Pair<BedrockGunModel, class_2960> lodModel;
    private GunAnimationStateMachine animationStateMachine;
    @Nullable
    private class_2960 playerAnimator3rd = new class_2960("tacz", "rifle_default.player_animation");
    private Map<String, class_2960> sounds;
    private GunTransform transform;
    private GunData gunData;
    private class_2960 modelTexture;
    private class_2960 slotTexture;
    private class_2960 hudTexture;
    @Nullable
    private class_2960 hudEmptyTexture;
    private String type;
    private String itemType;
    @Nullable
    private ShellEjection shellEjection;
    @Nullable
    private MuzzleFlash muzzleFlash;
    private LayerGunShow offhandShow;
    @Nullable
    private Int2ObjectArrayMap<LayerGunShow> hotbarShow;
    private float ironZoom;
    private boolean showCrosshair = false;
    @Nullable
    private AmmoParticle particle;
    private float @Nullable [] tracerColor = null;

    private ClientGunIndex() {
    }

    public static ClientGunIndex getInstance(GunIndexPOJO gunIndexPOJO) throws IllegalArgumentException {
        ClientGunIndex index = new ClientGunIndex();
        ClientGunIndex.checkIndex(gunIndexPOJO, index);
        GunDisplay display = ClientGunIndex.checkDisplay(gunIndexPOJO);
        ClientGunIndex.checkData(gunIndexPOJO, index);
        ClientGunIndex.checkName(gunIndexPOJO, index);
        ClientGunIndex.checkTextureAndModel(display, index);
        ClientGunIndex.checkLod(display, index);
        ClientGunIndex.checkSlotTexture(display, index);
        ClientGunIndex.checkHUDTexture(display, index);
        ClientGunIndex.checkAnimation(display, index);
        ClientGunIndex.checkSounds(display, index);
        ClientGunIndex.checkTransform(display, index);
        ClientGunIndex.checkShellEjection(display, index);
        ClientGunIndex.checkGunAmmo(display, index);
        ClientGunIndex.checkMuzzleFlash(display, index);
        ClientGunIndex.checkLayerGunShow(display, index);
        ClientGunIndex.checkIronZoom(display, index);
        ClientGunIndex.checkTextShow(display, index);
        index.showCrosshair = display.isShowCrosshair();
        return index;
    }

    private static void checkIndex(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        Preconditions.checkArgument((gunIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gunIndexPOJO.getType()}), (Object)"index object missing type field");
        index.type = gunIndexPOJO.getType();
        index.itemType = gunIndexPOJO.getItemType();
    }

    private static void checkName(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        index.name = gunIndexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.tacz.error.no_name";
        }
    }

    private static void checkData(GunIndexPOJO gunIndexPOJO, ClientGunIndex index) {
        class_2960 pojoData = gunIndexPOJO.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        GunData data = CommonAssetManager.INSTANCE.getGunData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.gunData = data;
    }

    @NotNull
    private static GunDisplay checkDisplay(GunIndexPOJO gunIndexPOJO) {
        class_2960 pojoDisplay = gunIndexPOJO.getDisplay();
        Preconditions.checkArgument((pojoDisplay != null ? 1 : 0) != 0, (Object)"index object missing display field");
        GunDisplay display = ClientAssetManager.INSTANCE.getGunDisplay(pojoDisplay);
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        return display;
    }

    private static void checkIronZoom(GunDisplay display, ClientGunIndex index) {
        index.ironZoom = display.getIronZoom();
        if (index.ironZoom < 1.0f) {
            index.ironZoom = 1.0f;
        }
    }

    private static void checkTextShow(GunDisplay display, ClientGunIndex index) {
        HashMap textShowMap = Maps.newHashMap();
        display.getTextShows().forEach((key, value) -> {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
                int color = ColorHex.colorTextToRbgInt(value.getColorText());
                value.setColorInt(color);
                textShowMap.put(key, value);
            }
        });
        index.gunModel.setTextShowList(textShowMap);
    }

    private static void checkTextureAndModel(GunDisplay display, ClientGunIndex index) {
        class_2960 modelLocation = display.getModelLocation();
        Preconditions.checkArgument((modelLocation != null ? 1 : 0) != 0, (Object)"display object missing model field");
        BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(modelLocation);
        Preconditions.checkArgument((modelPOJO != null ? 1 : 0) != 0, (Object)"there is no corresponding model file");
        class_2960 textureLocation = display.getModelTexture();
        Preconditions.checkArgument((textureLocation != null ? 1 : 0) != 0, (Object)"missing default texture");
        index.modelTexture = textureLocation;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            index.gunModel = new BedrockGunModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            index.gunModel = new BedrockGunModel(modelPOJO, BedrockVersion.NEW);
        }
        Preconditions.checkArgument((index.gunModel != null ? 1 : 0) != 0, (Object)"there is no model data in the model file");
    }

    private static void checkLod(GunDisplay display, ClientGunIndex index) {
        GunLod gunLod = display.getGunLod();
        if (gunLod != null) {
            BedrockGunModel model;
            class_2960 texture = gunLod.getModelTexture();
            if (gunLod.getModelLocation() == null) {
                return;
            }
            if (texture == null) {
                return;
            }
            BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(gunLod.getModelLocation());
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                model = new BedrockGunModel(modelPOJO, BedrockVersion.LEGACY);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                model = new BedrockGunModel(modelPOJO, BedrockVersion.NEW);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
        }
    }

    private static void checkAnimation(GunDisplay display, ClientGunIndex index) {
        AnimationController controller;
        class_2960 location = display.getAnimationLocation();
        if (location == null) {
            controller = new AnimationController(Lists.newArrayList(), index.gunModel);
        } else {
            AnimationStructure gltfAnimations = ClientAssetManager.INSTANCE.getGltfAnimations(location);
            BedrockAnimationFile bedrockAnimationFile = ClientAssetManager.INSTANCE.getBedrockAnimations(location);
            if (bedrockAnimationFile != null) {
                controller = Animations.createControllerFromBedrock(bedrockAnimationFile, index.gunModel);
            } else if (gltfAnimations != null) {
                controller = Animations.createControllerFromGltf(gltfAnimations, index.gunModel);
            } else {
                throw new IllegalArgumentException("animation not found: " + String.valueOf(location));
            }
            DefaultAnimation defaultAnimation = display.getDefaultAnimation();
            if (defaultAnimation != null) {
                switch (defaultAnimation) {
                    case RIFLE: {
                        for (ObjectAnimation animation : InternalAssetLoader.getDefaultRifleAnimations()) {
                            controller.providePrototypeIfAbsent(animation.name, () -> new ObjectAnimation(animation));
                        }
                        break;
                    }
                    case PISTOL: {
                        for (ObjectAnimation animation : InternalAssetLoader.getDefaultPistolAnimations()) {
                            controller.providePrototypeIfAbsent(animation.name, () -> new ObjectAnimation(animation));
                        }
                        break;
                    }
                }
            }
        }
        index.animationStateMachine = new GunAnimationStateMachine(controller);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{display.getThirdPersonAnimation()})) {
            index.thirdPersonAnimation = display.getThirdPersonAnimation();
        }
        if (display.getPlayerAnimator3rd() != null) {
            index.playerAnimator3rd = display.getPlayerAnimator3rd();
        }
    }

    private static void checkSounds(GunDisplay display, ClientGunIndex index) {
        index.sounds = Maps.newHashMap();
        Map<String, class_2960> soundMaps = display.getSounds();
        if (soundMaps == null || soundMaps.isEmpty()) {
            return;
        }
        soundMaps.putIfAbsent(SoundManager.DRY_FIRE_SOUND, new class_2960("tacz", SoundManager.DRY_FIRE_SOUND));
        soundMaps.putIfAbsent(SoundManager.FIRE_SELECT, new class_2960("tacz", SoundManager.FIRE_SELECT));
        soundMaps.putIfAbsent(SoundManager.HEAD_HIT_SOUND, new class_2960("tacz", SoundManager.HEAD_HIT_SOUND));
        soundMaps.putIfAbsent(SoundManager.FLESH_HIT_SOUND, new class_2960("tacz", SoundManager.FLESH_HIT_SOUND));
        soundMaps.putIfAbsent(SoundManager.KILL_SOUND, new class_2960("tacz", SoundManager.KILL_SOUND));
        soundMaps.putIfAbsent(SoundManager.MELEE_BAYONET, new class_2960("tacz", "melee_bayonet/melee_bayonet_01"));
        soundMaps.putIfAbsent(SoundManager.MELEE_STOCK, new class_2960("tacz", "melee_stock/melee_stock_01"));
        soundMaps.putIfAbsent(SoundManager.MELEE_PUSH, new class_2960("tacz", "melee_stock/melee_stock_02"));
        index.sounds.putAll(soundMaps);
    }

    private static void checkTransform(GunDisplay display, ClientGunIndex index) {
        GunTransform readTransform = display.getTransform();
        GunDisplay defaultDisplay = ClientAssetManager.INSTANCE.getGunDisplay(DefaultAssets.DEFAULT_GUN_DISPLAY);
        index.transform = readTransform == null || readTransform.getScale() == null ? Objects.requireNonNull(defaultDisplay.getTransform()) : display.getTransform();
    }

    private static void checkSlotTexture(GunDisplay display, ClientGunIndex index) {
        index.slotTexture = Objects.requireNonNullElseGet(display.getSlotTextureLocation(), class_1047::method_4539);
    }

    private static void checkHUDTexture(GunDisplay display, ClientGunIndex index) {
        index.hudTexture = Objects.requireNonNullElseGet(display.getHudTextureLocation(), class_1047::method_4539);
        index.hudEmptyTexture = display.getHudEmptyTextureLocation();
    }

    private static void checkShellEjection(GunDisplay display, ClientGunIndex index) {
        index.shellEjection = display.getShellEjection();
    }

    private static void checkGunAmmo(GunDisplay display, ClientGunIndex index) {
        AmmoParticle particle;
        GunAmmo displayGunAmmo = display.getGunAmmo();
        if (displayGunAmmo == null) {
            return;
        }
        String tracerColorText = displayGunAmmo.getTracerColor();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tracerColorText})) {
            index.tracerColor = ColorHex.colorTextToRbgFloatArray(tracerColorText);
        }
        if ((particle = displayGunAmmo.getParticle()) != null) {
            try {
                String name = particle.getName();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[0])) {
                    particle.setParticleOptions(class_2223.method_9418((StringReader)new StringReader(name), (class_7225)class_7923.field_41180.method_46771()));
                    Preconditions.checkArgument((particle.getCount() > 0 ? 1 : 0) != 0, (Object)"particle count must be greater than 0");
                    Preconditions.checkArgument((particle.getLifeTime() > 0 ? 1 : 0) != 0, (Object)"particle life time must be greater than 0");
                    index.particle = particle;
                }
            }
            catch (CommandSyntaxException e) {
                e.fillInStackTrace();
            }
        }
    }

    private static void checkMuzzleFlash(GunDisplay display, ClientGunIndex index) {
        index.muzzleFlash = display.getMuzzleFlash();
        if (index.muzzleFlash != null && index.muzzleFlash.getTexture() == null) {
            index.muzzleFlash = null;
        }
    }

    private static void checkLayerGunShow(GunDisplay display, ClientGunIndex index) {
        Map<String, LayerGunShow> show;
        index.offhandShow = display.getOffhandShow();
        if (index.offhandShow == null) {
            index.offhandShow = new LayerGunShow();
        }
        if ((show = display.getHotbarShow()) == null || show.isEmpty()) {
            return;
        }
        index.hotbarShow = new Int2ObjectArrayMap();
        for (String key : show.keySet()) {
            try {
                index.hotbarShow.put(Integer.parseInt(key), (Object)show.get(key));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("index number is error: " + key);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getName() {
        return this.name;
    }

    public BedrockGunModel getGunModel() {
        return this.gunModel;
    }

    @Nullable
    public Pair<BedrockGunModel, class_2960> getLodModel() {
        return this.lodModel;
    }

    public GunAnimationStateMachine getAnimationStateMachine() {
        return this.animationStateMachine;
    }

    @Nullable
    public class_2960 getSounds(String name) {
        return this.sounds.get(name);
    }

    public GunTransform getTransform() {
        return this.transform;
    }

    public class_2960 getSlotTexture() {
        return this.slotTexture;
    }

    public class_2960 getHUDTexture() {
        return this.hudTexture;
    }

    @Nullable
    public class_2960 getHudEmptyTexture() {
        return this.hudEmptyTexture;
    }

    public class_2960 getModelTexture() {
        return this.modelTexture;
    }

    public GunData getGunData() {
        return this.gunData;
    }

    public String getThirdPersonAnimation() {
        return this.thirdPersonAnimation;
    }

    @Nullable
    public ShellEjection getShellEjection() {
        return this.shellEjection;
    }

    @Nullable
    public float[] getTracerColor() {
        return this.tracerColor;
    }

    @Nullable
    public AmmoParticle getParticle() {
        return this.particle;
    }

    @Nullable
    public MuzzleFlash getMuzzleFlash() {
        return this.muzzleFlash;
    }

    public LayerGunShow getOffhandShow() {
        return this.offhandShow;
    }

    @Nullable
    public Int2ObjectArrayMap<LayerGunShow> getHotbarShow() {
        return this.hotbarShow;
    }

    public float getIronZoom() {
        return this.ironZoom;
    }

    public boolean isShowCrosshair() {
        return this.showCrosshair;
    }

    @Nullable
    public class_2960 getPlayerAnimator3rd() {
        return this.playerAnimator3rd;
    }
}

